/*
 * Decompiled with CFR 0.152.
 */
package org.roboid.robot.impl;

import java.util.ArrayList;
import org.roboid.robot.Device;
import org.roboid.robot.impl.NamedElementImpl;

abstract class DeviceImpl
extends NamedElementImpl
implements Device {
    private final int uid;
    private final int dataType;
    protected final int dataSize;
    private final Object eventLock = new Object();
    private boolean fired;
    private boolean event;
    protected final ArrayList<Device.DeviceDataChangedListener> listeners = new ArrayList();

    protected DeviceImpl(int uid, String name, int dataType, int dataSize) {
        super(name);
        this.uid = uid;
        this.dataType = dataType;
        this.dataSize = dataSize;
    }

    protected int getUid() {
        return this.uid;
    }

    @Override
    public int getId() {
        return this.uid & 0xFFF00FFF;
    }

    @Override
    public int getProductId() {
        return (this.uid & 0xFF000) >> 12;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public int getDataSize() {
        return this.dataSize;
    }

    protected boolean isFired() {
        return this.fired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean e() {
        Object object = this.eventLock;
        synchronized (object) {
            return this.event;
        }
    }

    @Override
    public int read() {
        return 0;
    }

    @Override
    public int read(int index) {
        return 0;
    }

    @Override
    public int read(int[] data) {
        return 0;
    }

    @Override
    public float readFloat() {
        return 0.0f;
    }

    @Override
    public float readFloat(int index) {
        return 0.0f;
    }

    @Override
    public int readFloat(float[] data) {
        return 0;
    }

    @Override
    public String readString() {
        return "";
    }

    @Override
    public String readString(int index) {
        return "";
    }

    @Override
    public int readString(String[] data) {
        return 0;
    }

    @Override
    public boolean write(int data) {
        return false;
    }

    @Override
    public boolean write(int index, int data) {
        return false;
    }

    @Override
    public int write(int[] data) {
        return 0;
    }

    @Override
    public boolean writeFloat(float data) {
        return false;
    }

    @Override
    public boolean writeFloat(int index, float data) {
        return false;
    }

    @Override
    public int writeFloat(float[] data) {
        return 0;
    }

    @Override
    public boolean writeString(String data) {
        return false;
    }

    @Override
    public boolean writeString(int index, String data) {
        return false;
    }

    @Override
    public int writeString(String[] data) {
        return 0;
    }

    boolean put(int data) {
        return false;
    }

    boolean put(int index, int data) {
        return false;
    }

    int put(int[] data) {
        return 0;
    }

    boolean putFloat(float data) {
        return false;
    }

    boolean putFloat(int index, float data) {
        return false;
    }

    int putFloat(float[] data) {
        return 0;
    }

    boolean putString(String data) {
        return false;
    }

    boolean putString(int index, String data) {
        return false;
    }

    int putString(String[] data) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDeviceDataChangedListener(Device.DeviceDataChangedListener listener) {
        if (listener == null) {
            return;
        }
        ArrayList<Device.DeviceDataChangedListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.listeners.contains(listener)) {
                return;
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDeviceDataChangedListener(Device.DeviceDataChangedListener listener) {
        if (listener == null) {
            return;
        }
        ArrayList<Device.DeviceDataChangedListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDeviceDataChangedListener() {
        ArrayList<Device.DeviceDataChangedListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.clear();
        }
    }

    abstract void notifyDeviceDataChanged(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fire() {
        Object object = this.eventLock;
        synchronized (object) {
            this.fired = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDeviceState() {
        Object object = this.eventLock;
        synchronized (object) {
            this.event = this.fired;
            this.fired = false;
        }
    }
}

