/*
 * Decompiled with CFR 0.152.
 */
package org.roboid.robot.impl;

import org.roboid.robot.MotoringDevice;
import org.roboid.robot.impl.FloatDeviceImpl;

abstract class FloatMotoringDeviceImpl
extends FloatDeviceImpl
implements MotoringDevice {
    protected FloatMotoringDeviceImpl(int uid, String name, int dataType, int dataSize, Object initialValue, float minValue, float maxValue) {
        super(uid, name, dataType, dataSize, initialValue, minValue, maxValue);
    }

    @Override
    public boolean write(int data) {
        return this.writeFloat(data);
    }

    @Override
    public boolean write(int index, int data) {
        return this.writeFloat(index, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(int[] data) {
        if (data == null) {
            return 0;
        }
        int dataLen = data.length;
        if (dataLen <= 0) {
            return 0;
        }
        int len = 0;
        Object object = this.dataLock;
        synchronized (object) {
            int thisLen;
            block14: {
                float[] thisData;
                block13: {
                    thisData = this.data;
                    if (this.dataSize < 0 && (thisData == null || thisData.length != dataLen)) {
                        thisData = this.data = new float[dataLen];
                    }
                    if (thisData != null) break block13;
                    return 0;
                }
                thisLen = thisData.length;
                if (thisLen > 0) break block14;
                return 0;
            }
            len = Math.min(thisLen, dataLen);
            float minValue = this.minValue;
            float maxValue = this.maxValue;
            int i = 0;
            while (i < len) {
                float value = data[i];
                if (value < minValue) {
                    value = minValue;
                } else if (value > maxValue) {
                    value = maxValue;
                }
                thisData[i] = value;
                ++i;
            }
            i = len;
            while (i < thisLen) {
                thisData[i] = 0.0f;
                ++i;
            }
            this.fire();
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeFloat(float data) {
        Object object = this.dataLock;
        synchronized (object) {
            block8: {
                float[] thisData = this.data;
                if (thisData != null && thisData.length > 0) break block8;
                if (this.dataSize < 0) {
                    thisData = this.data = new float[1];
                    break block8;
                }
                return false;
            }
            if (data < this.minValue) {
                data = this.minValue;
            } else if (data > this.maxValue) {
                data = this.maxValue;
            }
            thisData[0] = data;
            this.fire();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeFloat(int index, float data) {
        if (index < 0) {
            return false;
        }
        Object object = this.dataLock;
        synchronized (object) {
            block12: {
                float[] thisData;
                block11: {
                    thisData = this.data;
                    if (thisData != null) break block11;
                    if (this.dataSize < 0) {
                        thisData = this.data = new float[index + 1];
                        this.fillInitialValue(thisData, 0, index);
                        break block12;
                    }
                    return false;
                }
                if (index < thisData.length) break block12;
                if (this.dataSize < 0) {
                    float[] newData = new float[index + 1];
                    int len = thisData.length;
                    System.arraycopy(thisData, 0, newData, 0, len);
                    this.fillInitialValue(newData, len, index);
                    this.data = newData;
                    thisData = newData;
                    break block12;
                }
                return false;
            }
            if (data < this.minValue) {
                data = this.minValue;
            } else if (data > this.maxValue) {
                data = this.maxValue;
            }
            thisData[index] = data;
            this.fire();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeFloat(float[] data) {
        if (data == null) {
            return 0;
        }
        int dataLen = data.length;
        if (dataLen <= 0) {
            return 0;
        }
        int len = 0;
        Object object = this.dataLock;
        synchronized (object) {
            int thisLen;
            block14: {
                float[] thisData;
                block13: {
                    thisData = this.data;
                    if (this.dataSize < 0 && (thisData == null || thisData.length != dataLen)) {
                        thisData = this.data = new float[dataLen];
                    }
                    if (thisData != null) break block13;
                    return 0;
                }
                thisLen = thisData.length;
                if (thisLen > 0) break block14;
                return 0;
            }
            len = Math.min(thisLen, dataLen);
            float minValue = this.minValue;
            float maxValue = this.maxValue;
            int i = 0;
            while (i < len) {
                float value = data[i];
                if (value < minValue) {
                    value = minValue;
                } else if (value > maxValue) {
                    value = maxValue;
                }
                thisData[i] = value;
                ++i;
            }
            i = len;
            while (i < thisLen) {
                thisData[i] = 0.0f;
                ++i;
            }
            this.fire();
        }
        return len;
    }
}

