/*
 * Decompiled with CFR 0.152.
 */
package org.roboid.robot.impl;

import java.util.ArrayList;
import org.roboid.robot.Device;
import org.roboid.robot.impl.DeviceImpl;

abstract class IntDeviceImpl
extends DeviceImpl {
    private final Object initialValue;
    protected final int minValue;
    protected final int maxValue;
    protected final Object dataLock = new Object();
    protected int[] data;

    protected IntDeviceImpl(int uid, String name, int dataType, int dataSize, Object initialValue, int minValue, int maxValue) {
        super(uid, name, dataType, dataSize);
        this.initialValue = initialValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        if (dataSize < 0) {
            return;
        }
        this.data = new int[dataSize];
        this.fillInitialValue(this.data, 0, dataSize);
    }

    protected void fillInitialValue(int[] data, int start, int end) {
        block12: {
            Object value;
            block14: {
                block13: {
                    block11: {
                        value = this.initialValue;
                        if (!(value instanceof Integer)) break block11;
                        int v = (Integer)value;
                        int i = start;
                        while (i < end) {
                            data[i] = v;
                            ++i;
                        }
                        break block12;
                    }
                    if (!(value instanceof Float)) break block13;
                    int v = (int)((Float)value).floatValue();
                    int i = start;
                    while (i < end) {
                        data[i] = v;
                        ++i;
                    }
                    break block12;
                }
                if (!(value instanceof int[])) break block14;
                int[] v = (int[])value;
                int len = Math.min(end, v.length);
                if (start >= len) {
                    int i = start;
                    while (i < end) {
                        data[i] = 0;
                        ++i;
                    }
                } else {
                    System.arraycopy(v, start, data, start, len - start);
                    int i = len;
                    while (i < end) {
                        data[i] = 0;
                        ++i;
                    }
                }
                break block12;
            }
            if (!(value instanceof float[])) break block12;
            float[] v = (float[])value;
            int len = Math.min(end, v.length);
            if (start >= len) {
                int i = start;
                while (i < end) {
                    data[i] = 0;
                    ++i;
                }
            } else {
                int i = start;
                while (i < len) {
                    data[i] = (int)v[i];
                    ++i;
                }
                i = len;
                while (i < end) {
                    data[i] = 0;
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() {
        Object object = this.dataLock;
        synchronized (object) {
            int[] thisData;
            block4: {
                thisData = this.data;
                if (thisData != null && thisData.length > 0) break block4;
                return 0;
            }
            return thisData[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(int index) {
        if (index < 0) {
            return 0;
        }
        Object object = this.dataLock;
        synchronized (object) {
            int[] thisData;
            block5: {
                thisData = this.data;
                if (thisData != null && index < thisData.length) break block5;
                return 0;
            }
            return thisData[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(int[] data) {
        if (data == null) {
            return 0;
        }
        int dataLen = data.length;
        if (dataLen <= 0) {
            return 0;
        }
        int len = 0;
        Object object = this.dataLock;
        synchronized (object) {
            int[] thisData;
            block7: {
                thisData = this.data;
                if (thisData != null) break block7;
                return 0;
            }
            len = Math.min(thisData.length, dataLen);
            System.arraycopy(thisData, 0, data, 0, len);
        }
        int i = len;
        while (i < dataLen) {
            data[i] = 0;
            ++i;
        }
        return len;
    }

    @Override
    public float readFloat() {
        return this.read();
    }

    @Override
    public float readFloat(int index) {
        return this.read(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readFloat(float[] data) {
        if (data == null) {
            return 0;
        }
        int dataLen = data.length;
        if (dataLen <= 0) {
            return 0;
        }
        int len = 0;
        Object object = this.dataLock;
        synchronized (object) {
            int[] thisData;
            block8: {
                thisData = this.data;
                if (thisData != null) break block8;
                return 0;
            }
            len = Math.min(thisData.length, dataLen);
            int i = 0;
            while (i < len) {
                data[i] = thisData[i];
                ++i;
            }
        }
        int i = len;
        while (i < dataLen) {
            data[i] = 0.0f;
            ++i;
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean put(int data) {
        Object object = this.dataLock;
        synchronized (object) {
            block8: {
                int[] thisData = this.data;
                if (thisData != null && thisData.length > 0) break block8;
                if (this.dataSize < 0) {
                    thisData = this.data = new int[1];
                    break block8;
                }
                return false;
            }
            if (data < this.minValue) {
                data = this.minValue;
            } else if (data > this.maxValue) {
                data = this.maxValue;
            }
            thisData[0] = data;
            this.fire();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean put(int index, int data) {
        if (index < 0) {
            return false;
        }
        Object object = this.dataLock;
        synchronized (object) {
            block12: {
                int[] thisData;
                block11: {
                    thisData = this.data;
                    if (thisData != null) break block11;
                    if (this.dataSize < 0) {
                        thisData = this.data = new int[index + 1];
                        this.fillInitialValue(thisData, 0, index);
                        break block12;
                    }
                    return false;
                }
                if (index < thisData.length) break block12;
                if (this.dataSize < 0) {
                    int[] newData = new int[index + 1];
                    int len = thisData.length;
                    System.arraycopy(thisData, 0, newData, 0, len);
                    this.fillInitialValue(newData, len, index);
                    this.data = newData;
                    thisData = newData;
                    break block12;
                }
                return false;
            }
            if (data < this.minValue) {
                data = this.minValue;
            } else if (data > this.maxValue) {
                data = this.maxValue;
            }
            thisData[index] = data;
            this.fire();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int put(int[] data) {
        if (data == null) {
            return 0;
        }
        int dataLen = data.length;
        if (dataLen <= 0) {
            return 0;
        }
        int len = 0;
        Object object = this.dataLock;
        synchronized (object) {
            int thisLen;
            block14: {
                int[] thisData;
                block13: {
                    thisData = this.data;
                    if (this.dataSize < 0 && (thisData == null || thisData.length != dataLen)) {
                        thisData = this.data = new int[dataLen];
                    }
                    if (thisData != null) break block13;
                    return 0;
                }
                thisLen = thisData.length;
                if (thisLen > 0) break block14;
                return 0;
            }
            len = Math.min(thisLen, dataLen);
            int minValue = this.minValue;
            int maxValue = this.maxValue;
            int i = 0;
            while (i < len) {
                int value = data[i];
                if (value < minValue) {
                    value = minValue;
                } else if (value > maxValue) {
                    value = maxValue;
                }
                thisData[i] = value;
                ++i;
            }
            i = len;
            while (i < thisLen) {
                thisData[i] = 0;
                ++i;
            }
            this.fire();
        }
        return len;
    }

    @Override
    boolean putFloat(float data) {
        return this.put((int)data);
    }

    @Override
    boolean putFloat(int index, float data) {
        return this.put(index, (int)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int putFloat(float[] data) {
        if (data == null) {
            return 0;
        }
        int dataLen = data.length;
        if (dataLen <= 0) {
            return 0;
        }
        int len = 0;
        Object object = this.dataLock;
        synchronized (object) {
            int thisLen;
            block14: {
                int[] thisData;
                block13: {
                    thisData = this.data;
                    if (this.dataSize < 0 && (thisData == null || thisData.length != dataLen)) {
                        thisData = this.data = new int[dataLen];
                    }
                    if (thisData != null) break block13;
                    return 0;
                }
                thisLen = thisData.length;
                if (thisLen > 0) break block14;
                return 0;
            }
            len = Math.min(thisLen, dataLen);
            int minValue = this.minValue;
            int maxValue = this.maxValue;
            int i = 0;
            while (i < len) {
                int value = (int)data[i];
                if (value < minValue) {
                    value = minValue;
                } else if (value > maxValue) {
                    value = maxValue;
                }
                thisData[i] = value;
                ++i;
            }
            i = len;
            while (i < thisLen) {
                thisData[i] = 0;
                ++i;
            }
            this.fire();
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void notifyDeviceDataChanged(long timestamp) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            for (Device.DeviceDataChangedListener listener : this.listeners) {
                listener.onDeviceDataChanged(this, this.data, timestamp);
            }
        }
    }
}

