/*
 * Decompiled with CFR 0.152.
 */
package org.roboid.robot.impl;

import org.roboid.robot.MotoringDevice;
import org.roboid.robot.impl.IntDeviceImpl;

abstract class IntMotoringDeviceImpl
extends IntDeviceImpl
implements MotoringDevice {
    protected IntMotoringDeviceImpl(int uid, String name, int dataType, int dataSize, Object initialValue, int minValue, int maxValue) {
        super(uid, name, dataType, dataSize, initialValue, minValue, maxValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(int data) {
        Object object = this.dataLock;
        synchronized (object) {
            block8: {
                int[] thisData = this.data;
                if (thisData != null && thisData.length > 0) break block8;
                if (this.dataSize < 0) {
                    thisData = this.data = new int[1];
                    break block8;
                }
                return false;
            }
            if (data < this.minValue) {
                data = this.minValue;
            } else if (data > this.maxValue) {
                data = this.maxValue;
            }
            thisData[0] = data;
            this.fire();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(int index, int data) {
        if (index < 0) {
            return false;
        }
        Object object = this.dataLock;
        synchronized (object) {
            block12: {
                int[] thisData;
                block11: {
                    thisData = this.data;
                    if (thisData != null) break block11;
                    if (this.dataSize < 0) {
                        thisData = this.data = new int[index + 1];
                        this.fillInitialValue(thisData, 0, index);
                        break block12;
                    }
                    return false;
                }
                if (index < thisData.length) break block12;
                if (this.dataSize < 0) {
                    int[] newData = new int[index + 1];
                    int len = thisData.length;
                    System.arraycopy(thisData, 0, newData, 0, len);
                    this.fillInitialValue(newData, len, index);
                    this.data = newData;
                    thisData = newData;
                    break block12;
                }
                return false;
            }
            if (data < this.minValue) {
                data = this.minValue;
            } else if (data > this.maxValue) {
                data = this.maxValue;
            }
            thisData[index] = data;
            this.fire();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(int[] data) {
        if (data == null) {
            return 0;
        }
        int dataLen = data.length;
        if (dataLen <= 0) {
            return 0;
        }
        int len = 0;
        Object object = this.dataLock;
        synchronized (object) {
            int thisLen;
            block14: {
                int[] thisData;
                block13: {
                    thisData = this.data;
                    if (this.dataSize < 0 && (thisData == null || thisData.length != dataLen)) {
                        thisData = this.data = new int[dataLen];
                    }
                    if (thisData != null) break block13;
                    return 0;
                }
                thisLen = thisData.length;
                if (thisLen > 0) break block14;
                return 0;
            }
            len = Math.min(thisLen, dataLen);
            int minValue = this.minValue;
            int maxValue = this.maxValue;
            int i = 0;
            while (i < len) {
                int value = data[i];
                if (value < minValue) {
                    value = minValue;
                } else if (value > maxValue) {
                    value = maxValue;
                }
                thisData[i] = value;
                ++i;
            }
            i = len;
            while (i < thisLen) {
                thisData[i] = 0;
                ++i;
            }
            this.fire();
        }
        return len;
    }

    @Override
    public boolean writeFloat(float data) {
        return this.write((int)data);
    }

    @Override
    public boolean writeFloat(int index, float data) {
        return this.write(index, (int)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeFloat(float[] data) {
        if (data == null) {
            return 0;
        }
        int dataLen = data.length;
        if (dataLen <= 0) {
            return 0;
        }
        int len = 0;
        Object object = this.dataLock;
        synchronized (object) {
            int thisLen;
            block14: {
                int[] thisData;
                block13: {
                    thisData = this.data;
                    if (this.dataSize < 0 && (thisData == null || thisData.length != dataLen)) {
                        thisData = this.data = new int[dataLen];
                    }
                    if (thisData != null) break block13;
                    return 0;
                }
                thisLen = thisData.length;
                if (thisLen > 0) break block14;
                return 0;
            }
            len = Math.min(thisLen, dataLen);
            int minValue = this.minValue;
            int maxValue = this.maxValue;
            int i = 0;
            while (i < len) {
                int value = (int)data[i];
                if (value < minValue) {
                    value = minValue;
                } else if (value > maxValue) {
                    value = maxValue;
                }
                thisData[i] = value;
                ++i;
            }
            i = len;
            while (i < thisLen) {
                thisData[i] = 0;
                ++i;
            }
            this.fire();
        }
        return len;
    }
}

