/*
 * Decompiled with CFR 0.152.
 */
package org.roboid.robot.impl;

import java.util.ArrayList;
import org.roboid.robot.Device;
import org.roboid.robot.MotoringDevice;
import org.roboid.robot.Roboid;
import org.roboid.robot.SensoryDevice;
import org.roboid.robot.impl.DeviceImpl;
import org.roboid.robot.impl.FloatCommandImpl;
import org.roboid.robot.impl.FloatEffectorImpl;
import org.roboid.robot.impl.FloatEventImpl;
import org.roboid.robot.impl.FloatSensorImpl;
import org.roboid.robot.impl.IntCommandImpl;
import org.roboid.robot.impl.IntEffectorImpl;
import org.roboid.robot.impl.IntEventImpl;
import org.roboid.robot.impl.IntSensorImpl;
import org.roboid.robot.impl.NamedElementImpl;
import org.roboid.robot.impl.StringCommandImpl;
import org.roboid.robot.impl.StringEffectorImpl;
import org.roboid.robot.impl.StringEventImpl;
import org.roboid.robot.impl.StringSensorImpl;

public abstract class RoboidImpl
extends NamedElementImpl
implements Roboid {
    protected static final int SENSOR = 0;
    protected static final int EFFECTOR = 1;
    protected static final int COMMAND = 2;
    protected static final int EVENT = 3;
    private int mask;
    private final ArrayList<Roboid> roboids = new ArrayList();
    private final ArrayList<Device> devices = new ArrayList();

    protected RoboidImpl(String name, int mask) {
        super(name);
        this.mask = mask;
    }

    protected Device addDevice(int deviceType, int uid, String name, int dataType, int dataSize, Object initialValue, float minValue, float maxValue) {
        DeviceImpl device = null;
        block0 : switch (deviceType) {
            case 0: {
                switch (dataType) {
                    case 4: {
                        device = new IntSensorImpl(uid, name, dataType, dataSize, initialValue, (int)minValue, (int)maxValue);
                        break;
                    }
                    case 5: {
                        device = new FloatSensorImpl(uid, name, dataType, dataSize, initialValue, minValue, maxValue);
                        break;
                    }
                    case 6: {
                        device = new StringSensorImpl(uid, name, dataType, dataSize, initialValue);
                    }
                }
                break;
            }
            case 1: {
                switch (dataType) {
                    case 4: {
                        device = new IntEffectorImpl(uid, name, dataType, dataSize, initialValue, (int)minValue, (int)maxValue);
                        break;
                    }
                    case 5: {
                        device = new FloatEffectorImpl(uid, name, dataType, dataSize, initialValue, minValue, maxValue);
                        break;
                    }
                    case 6: {
                        device = new StringEffectorImpl(uid, name, dataType, dataSize, initialValue);
                    }
                }
                break;
            }
            case 2: {
                switch (dataType) {
                    case 4: {
                        device = new IntCommandImpl(uid, name, dataType, dataSize, initialValue, (int)minValue, (int)maxValue);
                        break;
                    }
                    case 5: {
                        device = new FloatCommandImpl(uid, name, dataType, dataSize, initialValue, minValue, maxValue);
                        break;
                    }
                    case 6: {
                        device = new StringCommandImpl(uid, name, dataType, dataSize, initialValue);
                    }
                }
                break;
            }
            case 3: {
                switch (dataType) {
                    case 4: {
                        device = new IntEventImpl(uid, name, dataType, dataSize, initialValue, (int)minValue, (int)maxValue);
                        break block0;
                    }
                    case 5: {
                        device = new FloatEventImpl(uid, name, dataType, dataSize, initialValue, minValue, maxValue);
                        break block0;
                    }
                    case 6: {
                        device = new StringEventImpl(uid, name, dataType, dataSize, initialValue);
                    }
                }
            }
        }
        if (device != null) {
            this.devices.add(device);
        }
        return device;
    }

    protected boolean isFired(Device device) {
        return ((DeviceImpl)device).isFired();
    }

    protected boolean put(Device device, int data) {
        return ((DeviceImpl)device).put(data);
    }

    protected boolean put(Device device, int index, int data) {
        return ((DeviceImpl)device).put(index, data);
    }

    protected int put(Device device, int[] data) {
        return ((DeviceImpl)device).put(data);
    }

    protected boolean putFloat(Device device, float data) {
        return ((DeviceImpl)device).putFloat(data);
    }

    protected boolean putFloat(Device device, int index, float data) {
        return ((DeviceImpl)device).putFloat(index, data);
    }

    protected int putFloat(Device device, float[] data) {
        return ((DeviceImpl)device).putFloat(data);
    }

    protected boolean putString(Device device, String data) {
        return ((DeviceImpl)device).putString(data);
    }

    protected boolean putString(Device device, int index, String data) {
        return ((DeviceImpl)device).putString(index, data);
    }

    protected int putString(Device device, String[] data) {
        return ((DeviceImpl)device).putString(data);
    }

    protected void addRoboid(Roboid roboid) {
        if (roboid == null) {
            return;
        }
        if (this.roboids.contains(roboid)) {
            return;
        }
        this.roboids.add(roboid);
    }

    @Override
    public Roboid findRoboidByName(String name) {
        if (name == null || name.length() <= 0) {
            return null;
        }
        int dot = name.indexOf(".");
        if (dot < 0) {
            for (Roboid roboid : this.roboids) {
                if (!name.equalsIgnoreCase(roboid.getName())) continue;
                return roboid;
            }
        } else {
            String roboidName = name.substring(0, dot);
            String subName = name.substring(dot + 1);
            for (Roboid roboid : this.roboids) {
                if (!roboidName.equalsIgnoreCase(roboid.getName())) continue;
                return roboid.findRoboidByName(subName);
            }
        }
        return null;
    }

    @Override
    public Device findDeviceByName(String name) {
        if (name == null || name.length() <= 0) {
            return null;
        }
        int dot = name.indexOf(".");
        if (dot < 0) {
            for (Device device : this.devices) {
                if (!name.equalsIgnoreCase(device.getName())) continue;
                return device;
            }
        } else {
            String roboidName = name.substring(0, dot);
            String subName = name.substring(dot + 1);
            for (Roboid roboid : this.roboids) {
                if (!roboidName.equalsIgnoreCase(roboid.getName())) continue;
                return roboid.findDeviceByName(subName);
            }
        }
        return null;
    }

    @Override
    public Device findDeviceById(int deviceId) {
        return this.findDevice(deviceId);
    }

    protected Device findDevice(int uid) {
        int mask = uid & 0xFFFFF000;
        if (mask == this.mask) {
            for (Device device : this.devices) {
                if (((DeviceImpl)device).getUid() != uid) continue;
                return device;
            }
            return null;
        }
        Device device = null;
        for (Roboid roboid : this.roboids) {
            device = ((RoboidImpl)roboid).findDevice(uid);
            if (device == null) continue;
            return device;
        }
        return null;
    }

    @Override
    public void addDeviceDataChangedListener(Device.DeviceDataChangedListener listener) {
        if (listener == null) {
            return;
        }
        for (Device device : this.devices) {
            device.addDeviceDataChangedListener(listener);
        }
        for (Roboid roboid : this.roboids) {
            roboid.addDeviceDataChangedListener(listener);
        }
    }

    @Override
    public void removeDeviceDataChangedListener(Device.DeviceDataChangedListener listener) {
        if (listener == null) {
            return;
        }
        for (Device device : this.devices) {
            device.removeDeviceDataChangedListener(listener);
        }
        for (Roboid roboid : this.roboids) {
            roboid.removeDeviceDataChangedListener(listener);
        }
    }

    @Override
    public void clearDeviceDataChangedListener() {
        for (Device device : this.devices) {
            device.clearDeviceDataChangedListener();
        }
        for (Roboid roboid : this.roboids) {
            roboid.clearDeviceDataChangedListener();
        }
    }

    protected void updateSensoryDeviceState() {
        for (Device device : this.devices) {
            if (!(device instanceof SensoryDevice)) continue;
            ((DeviceImpl)device).updateDeviceState();
        }
        for (Roboid roboid : this.roboids) {
            ((RoboidImpl)roboid).updateSensoryDeviceState();
        }
    }

    protected void updateMotoringDeviceState() {
        for (Device device : this.devices) {
            if (!(device instanceof MotoringDevice)) continue;
            ((DeviceImpl)device).updateDeviceState();
        }
        for (Roboid roboid : this.roboids) {
            ((RoboidImpl)roboid).updateMotoringDeviceState();
        }
    }

    protected void notifySensoryDeviceDataChanged(long timestamp) {
        for (Device device : this.devices) {
            if (!(device instanceof SensoryDevice)) continue;
            ((DeviceImpl)device).notifyDeviceDataChanged(timestamp);
        }
        for (Roboid roboid : this.roboids) {
            ((RoboidImpl)roboid).notifySensoryDeviceDataChanged(timestamp);
        }
    }

    protected void notifyMotoringDeviceDataChanged(long timestamp) {
        for (Device device : this.devices) {
            if (!(device instanceof MotoringDevice)) continue;
            ((DeviceImpl)device).notifyDeviceDataChanged(timestamp);
        }
        for (Roboid roboid : this.roboids) {
            ((RoboidImpl)roboid).notifyMotoringDeviceDataChanged(timestamp);
        }
    }
}

