/*
 * Decompiled with CFR 0.152.
 */
package org.roboid.robot.impl;

import java.util.ArrayList;
import org.roboid.robot.Device;
import org.roboid.robot.Roboid;
import org.roboid.robot.Robot;
import org.roboid.robot.impl.NamedElementImpl;
import org.roboid.robot.impl.RoboidImpl;

public abstract class RobotImpl
extends NamedElementImpl
implements Robot {
    private final ArrayList<Roboid> roboids = new ArrayList();

    protected RobotImpl(String name) {
        super(name);
    }

    protected void addRoboid(Roboid roboid) {
        if (roboid == null) {
            return;
        }
        if (this.roboids.contains(roboid)) {
            return;
        }
        this.roboids.add(roboid);
    }

    @Override
    public Roboid findRoboidByName(String name) {
        if (name == null || name.length() <= 0) {
            return null;
        }
        int dot = name.indexOf(".");
        if (dot < 0) {
            for (Roboid roboid : this.roboids) {
                if (!name.equalsIgnoreCase(roboid.getName())) continue;
                return roboid;
            }
        } else {
            String roboidName = name.substring(0, dot);
            String subName = name.substring(dot + 1);
            for (Roboid roboid : this.roboids) {
                if (!roboidName.equalsIgnoreCase(roboid.getName())) continue;
                return roboid.findRoboidByName(subName);
            }
        }
        return null;
    }

    @Override
    public Device findDeviceByName(String name) {
        if (name == null || name.length() <= 0) {
            return null;
        }
        int dot = name.indexOf(".");
        if (dot >= 0) {
            String roboidName = name.substring(0, dot);
            String subName = name.substring(dot + 1);
            for (Roboid roboid : this.roboids) {
                if (!roboidName.equalsIgnoreCase(roboid.getName())) continue;
                return roboid.findDeviceByName(subName);
            }
        }
        return null;
    }

    @Override
    public Device findDeviceById(int deviceId) {
        Device device = null;
        for (Roboid roboid : this.roboids) {
            device = ((RoboidImpl)roboid).findDevice(deviceId);
            if (device == null) continue;
            return device;
        }
        return null;
    }

    @Override
    public boolean e(int deviceId) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return false;
        }
        return device.e();
    }

    @Override
    public int read(int deviceId) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return 0;
        }
        return device.read();
    }

    @Override
    public int read(int deviceId, int index) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return 0;
        }
        return device.read(index);
    }

    @Override
    public int read(int deviceId, int[] data) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return 0;
        }
        return device.read(data);
    }

    @Override
    public float readFloat(int deviceId) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return 0.0f;
        }
        return device.readFloat();
    }

    @Override
    public float readFloat(int deviceId, int index) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return 0.0f;
        }
        return device.readFloat(index);
    }

    @Override
    public int readFloat(int deviceId, float[] data) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return 0;
        }
        return device.readFloat(data);
    }

    @Override
    public String readString(int deviceId) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return "";
        }
        return device.readString();
    }

    @Override
    public String readString(int deviceId, int index) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return "";
        }
        return device.readString(index);
    }

    @Override
    public int readString(int deviceId, String[] data) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return 0;
        }
        return device.readString(data);
    }

    @Override
    public boolean write(int deviceId, int data) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return false;
        }
        return device.write(data);
    }

    @Override
    public boolean write(int deviceId, int index, int data) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return false;
        }
        return device.write(index, data);
    }

    @Override
    public int write(int deviceId, int[] data) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return 0;
        }
        return device.write(data);
    }

    @Override
    public boolean writeFloat(int deviceId, float data) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return false;
        }
        return device.writeFloat(data);
    }

    @Override
    public boolean writeFloat(int deviceId, int index, float data) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return false;
        }
        return device.writeFloat(index, data);
    }

    @Override
    public int writeFloat(int deviceId, float[] data) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return 0;
        }
        return device.writeFloat(data);
    }

    @Override
    public boolean writeString(int deviceId, String data) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return false;
        }
        return device.writeString(data);
    }

    @Override
    public boolean writeString(int deviceId, int index, String data) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return false;
        }
        return device.writeString(index, data);
    }

    @Override
    public int writeString(int deviceId, String[] data) {
        Device device = this.findDeviceById(deviceId);
        if (device == null) {
            return 0;
        }
        return device.writeString(data);
    }

    @Override
    public void addDeviceDataChangedListener(Device.DeviceDataChangedListener listener) {
        if (listener == null) {
            return;
        }
        for (Roboid roboid : this.roboids) {
            roboid.addDeviceDataChangedListener(listener);
        }
    }

    @Override
    public void removeDeviceDataChangedListener(Device.DeviceDataChangedListener listener) {
        if (listener == null) {
            return;
        }
        for (Roboid roboid : this.roboids) {
            roboid.removeDeviceDataChangedListener(listener);
        }
    }

    @Override
    public void clearDeviceDataChangedListener() {
        for (Roboid roboid : this.roboids) {
            roboid.clearDeviceDataChangedListener();
        }
    }

    protected void updateSensoryDeviceState() {
        for (Roboid roboid : this.roboids) {
            ((RoboidImpl)roboid).updateSensoryDeviceState();
        }
    }

    protected void updateMotoringDeviceState() {
        for (Roboid roboid : this.roboids) {
            ((RoboidImpl)roboid).updateMotoringDeviceState();
        }
    }

    protected void notifySensoryDeviceDataChanged(long timestamp) {
        for (Roboid roboid : this.roboids) {
            ((RoboidImpl)roboid).notifySensoryDeviceDataChanged(timestamp);
        }
    }

    protected void notifyMotoringDeviceDataChanged(long timestamp) {
        for (Roboid roboid : this.roboids) {
            ((RoboidImpl)roboid).notifyMotoringDeviceDataChanged(timestamp);
        }
    }
}

