/*
 * Decompiled with CFR 0.152.
 */
package org.roboid.robot.impl;

import java.util.ArrayList;
import org.roboid.robot.Device;
import org.roboid.robot.impl.DeviceImpl;

abstract class StringDeviceImpl
extends DeviceImpl {
    private final Object initialValue;
    protected final Object dataLock = new Object();
    protected String[] data;

    protected StringDeviceImpl(int uid, String name, int dataType, int dataSize, Object initialValue) {
        super(uid, name, dataType, dataSize);
        this.initialValue = initialValue;
        if (dataSize < 0) {
            return;
        }
        this.data = new String[dataSize];
        this.fillInitialValue(this.data, 0, dataSize);
    }

    protected void fillInitialValue(String[] data, int start, int end) {
        block7: {
            Object value;
            block6: {
                value = this.initialValue;
                if (!(value instanceof String)) break block6;
                String v = (String)value;
                int i = start;
                while (i < end) {
                    data[i] = v;
                    ++i;
                }
                break block7;
            }
            if (!(value instanceof String[])) break block7;
            String[] v = (String[])value;
            int len = Math.min(end, v.length);
            if (start >= len) {
                int i = start;
                while (i < end) {
                    data[i] = "";
                    ++i;
                }
            } else {
                int i = start;
                while (i < len) {
                    data[i] = v[i];
                    ++i;
                }
                i = len;
                while (i < end) {
                    data[i] = "";
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readString() {
        Object object = this.dataLock;
        synchronized (object) {
            String[] thisData;
            block4: {
                thisData = this.data;
                if (thisData != null && thisData.length > 0) break block4;
                return "";
            }
            return thisData[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readString(int index) {
        if (index < 0) {
            return "";
        }
        Object object = this.dataLock;
        synchronized (object) {
            String[] thisData;
            block5: {
                thisData = this.data;
                if (thisData != null && index < thisData.length) break block5;
                return "";
            }
            return thisData[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readString(String[] data) {
        if (data == null) {
            return 0;
        }
        int dataLen = data.length;
        if (dataLen <= 0) {
            return 0;
        }
        int len = 0;
        Object object = this.dataLock;
        synchronized (object) {
            String[] thisData;
            block8: {
                thisData = this.data;
                if (thisData != null) break block8;
                return 0;
            }
            len = Math.min(thisData.length, dataLen);
            int i = 0;
            while (i < len) {
                data[i] = thisData[i];
                ++i;
            }
        }
        int i = len;
        while (i < dataLen) {
            data[i] = "";
            ++i;
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean putString(String data) {
        Object object = this.dataLock;
        synchronized (object) {
            block5: {
                String[] thisData = this.data;
                if (thisData != null && thisData.length > 0) break block5;
                if (this.dataSize < 0) {
                    thisData = this.data = new String[1];
                    break block5;
                }
                return false;
            }
            thisData[0] = data;
            this.fire();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean putString(int index, String data) {
        if (index < 0) {
            return false;
        }
        Object object = this.dataLock;
        synchronized (object) {
            block10: {
                String[] thisData;
                block9: {
                    thisData = this.data;
                    if (thisData != null) break block9;
                    if (this.dataSize < 0) {
                        this.data = new String[index + 1];
                        thisData = this.data;
                        this.fillInitialValue(thisData, 0, index);
                        break block10;
                    }
                    return false;
                }
                if (index < thisData.length) break block10;
                if (this.dataSize < 0) {
                    String[] newData = new String[index + 1];
                    int len = thisData.length;
                    int i = 0;
                    while (i < len) {
                        newData[i] = thisData[i];
                        ++i;
                    }
                    this.fillInitialValue(newData, len, index);
                    this.data = newData;
                    thisData = newData;
                    break block10;
                }
                return false;
            }
            thisData[index] = data;
            this.fire();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int putString(String[] data) {
        if (data == null) {
            return 0;
        }
        int dataLen = data.length;
        if (dataLen <= 0) {
            return 0;
        }
        int len = 0;
        Object object = this.dataLock;
        synchronized (object) {
            int thisLen;
            block11: {
                String[] thisData;
                block10: {
                    thisData = this.data;
                    if (this.dataSize < 0 && (thisData == null || thisData.length != dataLen)) {
                        thisData = this.data = new String[dataLen];
                    }
                    if (thisData != null) break block10;
                    return 0;
                }
                thisLen = thisData.length;
                if (thisLen > 0) break block11;
                return 0;
            }
            len = Math.min(thisLen, dataLen);
            int i = 0;
            while (i < len) {
                thisData[i] = data[i];
                ++i;
            }
            i = len;
            while (i < thisLen) {
                thisData[i] = "";
                ++i;
            }
            this.fire();
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void notifyDeviceDataChanged(long timestamp) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            for (Device.DeviceDataChangedListener listener : this.listeners) {
                listener.onDeviceDataChanged(this, this.data, timestamp);
            }
        }
    }
}

