/*
 * Decompiled with CFR 0.152.
 */
package roboid.core;

import org.roboid.robot.Controller;
import org.roboid.robot.impl.RobotImpl;

public abstract class AbstractRobot
extends RobotImpl {
    private final int index;
    private Controller controller;

    protected AbstractRobot(String name, int index) {
        super(name);
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    protected void init() {
        this.createModel();
        RobotThread thread = new RobotThread();
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void dispose() {
    }

    protected abstract void createModel();

    protected abstract void encode();

    protected abstract boolean decode();

    private final class RobotThread
    extends Thread {
        private RobotThread() {
        }

        @Override
        public void run() {
            while (true) {
                if (AbstractRobot.this.decode()) {
                    AbstractRobot.this.notifySensoryDeviceDataChanged(System.nanoTime());
                    AbstractRobot.this.updateSensoryDeviceState();
                    if (AbstractRobot.this.controller != null) {
                        AbstractRobot.this.controller.execute(AbstractRobot.this);
                    }
                    AbstractRobot.this.encode();
                    AbstractRobot.this.notifyMotoringDeviceDataChanged(System.nanoTime());
                    AbstractRobot.this.updateMotoringDeviceState();
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

