/*
 * Decompiled with CFR 0.152.
 */
package roboid.core;

public final class HexUtil {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void valueToHex(StringBuilder sb, int value, int bytes) {
        int i = 0;
        while (i < bytes) {
            int val = value >> (bytes - i - 1) * 8;
            int high = val >> 4 & 0xF;
            int low = val & 0xF;
            sb.append(HEX_DIGITS[high]);
            sb.append(HEX_DIGITS[low]);
            ++i;
        }
    }

    public static int hexToValue(String str, int start, int end) {
        try {
            int result = 0;
            int i = start;
            while (i < end) {
                result <<= 4;
                result += HexUtil.hexCharToValue(str.charAt(i));
                ++i;
            }
            return result;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static int hexCharToValue(char character) {
        switch (character) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return character - 48;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return character - 97 + 10;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return character - 65 + 10;
            }
        }
        throw new NumberFormatException("Invalid hexadecimal");
    }
}

