/*
 * Decompiled with CFR 0.152.
 */
package roboid.core;

import jssc.SerialPort;
import roboid.core.ConnectionStateChangedListener;
import roboid.core.Connector;
import roboid.core.Serial;

public abstract class SerialConnector
implements Connector {
    private Serial serial;
    private final int packetLength;
    private final int delimiter;
    private String address = "000000000000";
    private String portName = "";
    private boolean found;
    private long timestamp;
    private boolean connected;
    private ConnectionStateChangedListener connectionStateChangedListener;
    private static final int RETRY = 10;
    private static final int TIMEOUT = 100000000;

    protected SerialConnector(int packetLength, int delimiter) {
        this.packetLength = packetLength;
        this.delimiter = delimiter;
    }

    protected void open(int baudrate, int flowcontrol) {
        String[] portNames = Serial.list();
        int i = 0;
        int len = portNames.length;
        while (i < len) {
            try {
                Serial serial = new Serial(portNames[i], baudrate);
                SerialPort port = serial.port;
                port.setFlowControlMode(flowcontrol);
                serial.clear();
                this.portName = portNames[i];
                if (this.checkPort(serial)) {
                    this.serial = serial;
                    return;
                }
                port.closePort();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        this.showError("No available USB to BLE bridge");
    }

    @Override
    public void close() {
        if (this.serial != null) {
            this.serial.dispose();
            this.serial = null;
        }
        this.connected = false;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    protected void setAddress(String address) {
        this.address = address;
    }

    protected void setConnectionState(int state) {
        boolean bl = this.connected = state == 2;
        if (!this.found && this.connected) {
            this.found = true;
        }
        if (this.found && this.connectionStateChangedListener != null) {
            this.connectionStateChangedListener.onConnectionStateChanged(state, this.portName);
        }
    }

    @Override
    public void setConnectionStateChangedListener(ConnectionStateChangedListener listener) {
        this.connectionStateChangedListener = listener;
    }

    protected abstract void showError(String var1);

    protected abstract boolean checkPort(Serial var1);

    protected abstract boolean checkConnection(Serial var1);

    protected String readPacket(Serial serial, String startByte) {
        int i = 0;
        while (i < 10) {
            try {
                Thread.sleep(10L);
                String packet = serial.readStringUntil(this.delimiter);
                if (packet != null) {
                    if (startByte == null) {
                        return packet;
                    }
                    if (packet.substring(0, 2).equals(startByte)) {
                        return packet;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    @Override
    public void write(String packet) {
        if (this.serial == null) {
            return;
        }
        try {
            this.serial.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String read() {
        if (this.serial == null) {
            return null;
        }
        try {
            String packet = this.serial.readStringUntil(this.delimiter);
            if (packet != null && packet.length() == this.packetLength) {
                if (!this.found) {
                    this.checkConnection(this.serial);
                } else if (!this.connected) {
                    this.setConnectionState(2);
                }
                this.timestamp = 0L;
                return packet;
            }
            if (this.connected) {
                long t = System.nanoTime();
                if (this.timestamp == 0L) {
                    this.timestamp = t;
                } else if (t - this.timestamp > 100000000L) {
                    this.setConnectionState(3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

