/*
 * Decompiled with CFR 0.152.
 */
package roboid.hamster;

import roboid.core.AbstractRobot;
import roboid.core.ConnectionStateChangedListener;
import roboid.core.Connector;
import roboid.core.RobotManager;
import roboid.hamster.HamsterRoboid;
import roboid.hamster.HamsterSerialConnector;

public final class Hamster
extends AbstractRobot {
    private final int type;
    private static int totalIndex;
    private Connector connector;
    private HamsterRoboid roboid;
    private ConnectionStateChangedListener connectionStateChangedListener = new ConnectionStateChangedListener(){

        @Override
        public void onConnectionStateChanged(int state, String info) {
            int index = Hamster.this.getIndex();
            if (state == 2) {
                System.out.println("Hamster[" + index + "] Connected: " + info);
            } else if (state == 3) {
                System.err.println("Hamster[" + index + "] Connection lost");
            }
        }
    };
    public static final int SERIAL = 0;
    public static final int BLE = 1;
    static final String ID = "kr.robomation.physical.hamster";
    public static final int LEFT_WHEEL = 0x400000;
    public static final int RIGHT_WHEEL = 0x400001;
    public static final int BUZZER = 0x400002;
    public static final int OUTPUT_A = 0x400003;
    public static final int OUTPUT_B = 0x400004;
    public static final int TOPOLOGY = 0x400005;
    public static final int LEFT_LED = 0x400006;
    public static final int RIGHT_LED = 0x400007;
    public static final int NOTE = 0x400008;
    public static final int LINE_TRACER_MODE = 0x400009;
    public static final int LINE_TRACER_SPEED = 0x40000A;
    public static final int IO_MODE_A = 0x40000B;
    public static final int IO_MODE_B = 0x40000C;
    public static final int CONFIG_PROXIMITY = 0x40000D;
    public static final int CONFIG_GRAVITY = 0x40000E;
    public static final int CONFIG_BAND_WIDTH = 0x40000F;
    public static final int SIGNAL_STRENGTH = 0x400010;
    public static final int LEFT_PROXIMITY = 0x400011;
    public static final int RIGHT_PROXIMITY = 4194322;
    public static final int LEFT_FLOOR = 4194323;
    public static final int RIGHT_FLOOR = 0x400014;
    public static final int ACCELERATION = 4194325;
    public static final int LIGHT = 4194326;
    public static final int TEMPERATURE = 4194327;
    public static final int BATTERY = 4194328;
    public static final int INPUT_A = 4194329;
    public static final int INPUT_B = 4194330;
    public static final int LINE_TRACER_STATE = 4194331;
    public static final int TOPOLOGY_NONE = 0;
    public static final int TOPOLOGY_DAISY_CHAIN = 1;
    public static final int TOPOLOGY_STAR = 2;
    public static final int TOPOLOGY_EXTENDED_STAR = 3;
    public static final int LED_OFF = 0;
    public static final int LED_BLUE = 1;
    public static final int LED_GREEN = 2;
    public static final int LED_CYAN = 3;
    public static final int LED_RED = 4;
    public static final int LED_MAGENTA = 5;
    public static final int LED_YELLOW = 6;
    public static final int LED_WHITE = 7;
    public static final int LINE_TRACER_MODE_OFF = 0;
    public static final int LINE_TRACER_MODE_BLACK_LEFT_SENSOR = 1;
    public static final int LINE_TRACER_MODE_BLACK_RIGHT_SENSOR = 2;
    public static final int LINE_TRACER_MODE_BLACK_BOTH_SENSORS = 3;
    public static final int LINE_TRACER_MODE_BLACK_TURN_LEFT = 4;
    public static final int LINE_TRACER_MODE_BLACK_TURN_RIGHT = 5;
    public static final int LINE_TRACER_MODE_BLACK_MOVE_FORWARD = 6;
    public static final int LINE_TRACER_MODE_BLACK_UTURN = 7;
    public static final int LINE_TRACER_MODE_WHITE_LEFT_SENSOR = 8;
    public static final int LINE_TRACER_MODE_WHITE_RIGHT_SENSOR = 9;
    public static final int LINE_TRACER_MODE_WHITE_BOTH_SENSORS = 10;
    public static final int LINE_TRACER_MODE_WHITE_TURN_LEFT = 11;
    public static final int LINE_TRACER_MODE_WHITE_TURN_RIGHT = 12;
    public static final int LINE_TRACER_MODE_WHITE_MOVE_FORWARD = 13;
    public static final int LINE_TRACER_MODE_WHITE_UTURN = 14;
    public static final int IO_MODE_ADC = 0;
    public static final int IO_MODE_DI = 1;
    public static final int IO_MODE_SERVO = 8;
    public static final int IO_MODE_PWM = 9;
    public static final int IO_MODE_DO = 10;

    public Hamster() {
        this(0);
    }

    public Hamster(int type) {
        super("Hamster", totalIndex++);
        this.type = type;
        this.init();
        RobotManager.registerRobot();
    }

    @Override
    public String getId() {
        return ID;
    }

    public static void waitUntilReady(int numberOfRobots) {
        RobotManager.waitUntilReady(numberOfRobots);
    }

    @Override
    protected void init() {
        super.init();
        if (this.type == 0) {
            this.connector = new HamsterSerialConnector(this.getIndex());
        }
        if (this.connector != null) {
            this.connector.setConnectionStateChangedListener(this.connectionStateChangedListener);
            this.connector.open();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.connector != null) {
            this.connector.close();
            this.connector = null;
        }
        System.out.println("Hamster[" + this.getIndex() + "] Disposed");
    }

    @Override
    protected void createModel() {
        this.roboid = new HamsterRoboid();
        this.roboid.createModel();
        this.addRoboid(this.roboid);
    }

    @Override
    protected void encode() {
        if (this.connector == null) {
            return;
        }
        String packet = this.roboid.encode(this.connector.getAddress());
        this.connector.write(packet);
    }

    @Override
    protected boolean decode() {
        String packet;
        if (this.connector != null && (packet = this.connector.read()) != null) {
            this.roboid.decode(packet);
            return true;
        }
        return false;
    }
}

