/*
 * Decompiled with CFR 0.152.
 */
package roboid.hamster;

import org.roboid.robot.Device;
import roboid.core.AbstractRoboid;
import roboid.core.HexUtil;

final class HamsterRoboid
extends AbstractRoboid {
    private Device leftWheelDevice;
    private Device rightWheelDevice;
    private Device buzzerDevice;
    private Device outputADevice;
    private Device outputBDevice;
    private Device topologyDevice;
    private Device leftLedDevice;
    private Device rightLedDevice;
    private Device noteDevice;
    private Device lineTracerModeDevice;
    private Device lineTracerSpeedDevice;
    private Device ioModeADevice;
    private Device ioModeBDevice;
    private Device configProximityDevice;
    private Device configGravityDevice;
    private Device configBandWidthDevice;
    private Device signalStrengthDevice;
    private Device leftProximityDevice;
    private Device rightProximityDevice;
    private Device leftFloorDevice;
    private Device rightFloorDevice;
    private Device accelerationDevice;
    private Device lightDevice;
    private Device temperatureDevice;
    private Device batteryDevice;
    private Device inputADevice;
    private Device inputBDevice;
    private Device lineTracerStateDevice;
    private int wheelBalance;
    private int lineTracerFlag;
    private int lineTracerState = -1;
    private int battery;
    private int batterySum;
    private int[] batteryData = new int[256];
    private int batteryCount;
    private boolean batteryInitial = true;

    protected HamsterRoboid() {
        super("Hamster", 0x400000);
    }

    @Override
    public String getId() {
        return "kr.robomation.physical.hamster";
    }

    @Override
    protected void createModel() {
        this.leftWheelDevice = this.addDevice(1, 0x400000, "LeftWheel", 4, 1, 0, -100.0f, 100.0f);
        this.rightWheelDevice = this.addDevice(1, 0x400001, "RightWheel", 4, 1, 0, -100.0f, 100.0f);
        this.buzzerDevice = this.addDevice(1, 0x400002, "Buzzer", 5, 1, 0, 0.0f, 167772.16f);
        this.outputADevice = this.addDevice(1, 0x400003, "OutputA", 4, 1, 0, 0.0f, 255.0f);
        this.outputBDevice = this.addDevice(1, 0x400004, "OutputB", 4, 1, 0, 0.0f, 255.0f);
        this.topologyDevice = this.addDevice(2, 0x400005, "Topology", 4, 1, 0, 0.0f, 15.0f);
        this.leftLedDevice = this.addDevice(2, 0x400006, "LeftLed", 4, 1, 0, 0.0f, 7.0f);
        this.rightLedDevice = this.addDevice(2, 0x400007, "RightLed", 4, 1, 0, 0.0f, 7.0f);
        this.noteDevice = this.addDevice(2, 0x400008, "Note", 4, 1, 0, 0.0f, 88.0f);
        this.lineTracerModeDevice = this.addDevice(2, 0x400009, "LineTracerMode", 4, 1, 0, 0.0f, 15.0f);
        this.lineTracerSpeedDevice = this.addDevice(2, 0x40000A, "LineTracerSpeed", 4, 1, 4, 0.0f, 7.0f);
        this.ioModeADevice = this.addDevice(2, 0x40000B, "IoModeA", 4, 1, 0, 0.0f, 15.0f);
        this.ioModeBDevice = this.addDevice(2, 0x40000C, "IoModeB", 4, 1, 0, 0.0f, 15.0f);
        this.configProximityDevice = this.addDevice(2, 0x40000D, "ConfigProximity", 4, 1, 2, 1.0f, 7.0f);
        this.configGravityDevice = this.addDevice(2, 0x40000E, "ConfigGravity", 4, 1, 0, 0.0f, 3.0f);
        this.configBandWidthDevice = this.addDevice(2, 0x40000F, "ConfigBandWidth", 4, 1, 3, 1.0f, 8.0f);
        this.signalStrengthDevice = this.addDevice(0, 0x400010, "SignalStrength", 4, 1, 0, -128.0f, 0.0f);
        this.leftProximityDevice = this.addDevice(0, 0x400011, "LeftProximity", 4, 1, 0, 0.0f, 255.0f);
        this.rightProximityDevice = this.addDevice(0, 4194322, "RightProximity", 4, 1, 0, 0.0f, 255.0f);
        this.leftFloorDevice = this.addDevice(0, 4194323, "LeftFloor", 4, 1, 0, 0.0f, 255.0f);
        this.rightFloorDevice = this.addDevice(0, 0x400014, "RightFloor", 4, 1, 0, 0.0f, 255.0f);
        this.accelerationDevice = this.addDevice(0, 4194325, "Acceleration", 4, 3, 0, -32768.0f, 32767.0f);
        this.lightDevice = this.addDevice(0, 4194326, "Light", 4, 1, 0, 0.0f, 65535.0f);
        this.temperatureDevice = this.addDevice(0, 4194327, "Temperature", 4, 1, 0, -40.0f, 88.0f);
        this.batteryDevice = this.addDevice(0, 4194328, "Battery", 4, 1, 0, 0.0f, 100.0f);
        this.inputADevice = this.addDevice(0, 4194329, "inputA", 4, 1, 0, 0.0f, 255.0f);
        this.inputBDevice = this.addDevice(0, 4194330, "inputB", 4, 1, 0, 0.0f, 255.0f);
        this.lineTracerStateDevice = this.addDevice(3, 4194331, "LineTracerState", 4, 1, 0, 0.0f, 255.0f);
    }

    String encode(String address) {
        StringBuilder sb = new StringBuilder();
        HexUtil.valueToHex(sb, this.topologyDevice.read() & 0xF, 1);
        sb.append("0010");
        HexUtil.valueToHex(sb, this.leftWheelDevice.read(), 1);
        HexUtil.valueToHex(sb, this.rightWheelDevice.read(), 1);
        HexUtil.valueToHex(sb, this.leftLedDevice.read(), 1);
        HexUtil.valueToHex(sb, this.rightLedDevice.read(), 1);
        HexUtil.valueToHex(sb, (int)(this.buzzerDevice.readFloat() * 100.0f), 3);
        HexUtil.valueToHex(sb, this.noteDevice.read(), 1);
        if (this.isFired(this.lineTracerModeDevice)) {
            this.lineTracerFlag ^= 0x80;
        }
        int temp = (this.lineTracerModeDevice.read() & 0xF) << 3;
        temp |= this.lineTracerSpeedDevice.read() & 7;
        HexUtil.valueToHex(sb, temp |= this.lineTracerFlag, 1);
        HexUtil.valueToHex(sb, this.configProximityDevice.read(), 1);
        temp = (this.configGravityDevice.read() & 0xF) << 4;
        HexUtil.valueToHex(sb, temp |= this.configBandWidthDevice.read() & 0xF, 1);
        temp = (this.ioModeADevice.read() & 0xF) << 4;
        HexUtil.valueToHex(sb, temp |= this.ioModeBDevice.read() & 0xF, 1);
        HexUtil.valueToHex(sb, this.outputADevice.read(), 1);
        HexUtil.valueToHex(sb, this.outputBDevice.read(), 1);
        HexUtil.valueToHex(sb, this.wheelBalance, 1);
        sb.append("0000-");
        sb.append(address);
        sb.append("\r");
        return sb.toString();
    }

    void decode(String packet) {
        if (packet == null) {
            return;
        }
        int value = HexUtil.hexToValue(packet, 6, 8);
        this.put(this.signalStrengthDevice, value -= 255);
        this.put(this.leftProximityDevice, HexUtil.hexToValue(packet, 8, 10));
        this.put(this.rightProximityDevice, HexUtil.hexToValue(packet, 10, 12));
        this.put(this.leftFloorDevice, HexUtil.hexToValue(packet, 12, 14));
        this.put(this.rightFloorDevice, HexUtil.hexToValue(packet, 14, 16));
        value = HexUtil.hexToValue(packet, 16, 20);
        if (value > Short.MAX_VALUE) {
            value -= 65535;
        }
        this.put(this.accelerationDevice, 0, value);
        value = HexUtil.hexToValue(packet, 20, 24);
        if (value > Short.MAX_VALUE) {
            value -= 65535;
        }
        this.put(this.accelerationDevice, 1, value);
        value = HexUtil.hexToValue(packet, 24, 28);
        if (value > Short.MAX_VALUE) {
            value -= 65535;
        }
        this.put(this.accelerationDevice, 2, value);
        value = HexUtil.hexToValue(packet, 28, 30);
        if (value == 0) {
            value = HexUtil.hexToValue(packet, 30, 34);
            this.put(this.lightDevice, value);
        } else {
            value = HexUtil.hexToValue(packet, 30, 32);
            value = (int)((float)value / 2.0f + 24.5f);
            this.put(this.temperatureDevice, value);
            value = HexUtil.hexToValue(packet, 32, 34);
            if (++this.batteryCount < 100) {
                int n = value;
                this.batteryData[n] = this.batteryData[n] + 1;
            } else {
                int max = 0;
                int index = 0;
                int i = 0;
                while (i < 256) {
                    if (this.batteryData[i] >= max) {
                        max = this.batteryData[i];
                        index = i;
                    }
                    this.batteryData[i] = 0;
                    ++i;
                }
                this.battery = index;
                this.batteryCount = 0;
                this.batteryInitial = false;
                this.battery = index >= 183 ? (int)((float)(index - 183) * 3.75f + 25.0f) : (index >= 170 ? (int)((float)(index - 170) * 0.77f + 15.0f) : index - 155);
                if (this.battery > 100) {
                    this.battery = 100;
                } else if (this.battery < 0) {
                    this.battery = 0;
                }
            }
            if (this.batteryInitial) {
                this.batterySum += value;
                float tmp = (float)this.batterySum / (float)this.batteryCount;
                this.battery = tmp >= 183.0f ? (int)((tmp - 183.0f) * 3.75f + 25.0f) : (tmp >= 170.0f ? (int)((tmp - 170.0f) * 0.77f + 15.0f) : (int)(tmp - 155.0f));
                if (this.battery > 100) {
                    this.battery = 100;
                } else if (this.battery < 0) {
                    this.battery = 0;
                }
            }
            this.put(this.batteryDevice, this.battery);
        }
        value = HexUtil.hexToValue(packet, 34, 36);
        this.put(this.inputADevice, value);
        value = HexUtil.hexToValue(packet, 36, 38);
        this.put(this.inputBDevice, value);
        value = HexUtil.hexToValue(packet, 38, 40);
        if (value != this.lineTracerState) {
            this.put(this.lineTracerStateDevice, value);
        }
    }
}

