/*
 * Decompiled with CFR 0.152.
 */
package roboid.hamster;

import roboid.core.Serial;
import roboid.core.SerialConnector;

final class HamsterSerialConnector
extends SerialConnector {
    private final int id;
    private static final int CR = 13;
    private static final int VALID_PACKET_LENGTH = 54;
    private static final int RETRY = 10;

    HamsterSerialConnector(int id) {
        super(54, 13);
        this.id = id;
    }

    @Override
    public void open() {
        this.open(115200, 3);
    }

    @Override
    protected boolean checkPort(Serial serial) {
        this.readPacket(serial, null);
        String packet1 = this.readPacket(serial, null);
        String packet2 = this.readPacket(serial, null);
        if (packet2 != null) {
            if (packet2.length() == 54) {
                return this.checkConnection(serial);
            }
            if (packet1 != null && packet2.length() == 2) {
                this.showError("Not connected");
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean checkConnection(Serial serial) {
        int i = 0;
        while (i < 10) {
            try {
                serial.write("FF\r");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String packet = this.readPacket(serial, "FF");
            if (packet != null) {
                String[] info = (packet = packet.trim()).split(",");
                if (info != null && info.length >= 5 && "Hamster".equals(info[1]) && "04".equals(info[2])) {
                    this.setAddress(info[4]);
                    this.setConnectionState(2);
                    return true;
                }
                return false;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected void showError(String message) {
        System.err.println("Hamster[" + this.id + "] " + message);
    }
}

