package examples.roboid.hamster;

import roboid.hamster.Hamster;

public class Example01_SimpleMovement {
	public static void main(String[] args) {
		final Hamster hamster = new Hamster();

		// move forward
		hamster.write(Hamster.LEFT_WHEEL, 50);
		hamster.write(Hamster.RIGHT_WHEEL, 50);
		wait(500);

		// move backward
		hamster.write(Hamster.LEFT_WHEEL, -50);
		hamster.write(Hamster.RIGHT_WHEEL, -50);
		wait(500);

		// stop
		hamster.write(Hamster.LEFT_WHEEL, 0);
		hamster.write(Hamster.RIGHT_WHEEL, 0);
		
		// don't forget to dispose
		hamster.dispose();
	}

	private static void wait(int millisec) {
		try {
			Thread.sleep(millisec);
		} catch (InterruptedException e) {
		}
	}
}