package examples.roboid.hamster;

import roboid.hamster.Hamster;

public class Example02_Acceleration {
	public static void main(String[] args) {
		final Hamster hamster = new Hamster();

		// acceleration
		for(int i = 0; i < 50; ++i) {
			hamster.write(Hamster.LEFT_WHEEL, i);
			hamster.write(Hamster.RIGHT_WHEEL, i);
			wait(20);
		}

		wait(500);

		// deceleration
		for(int i = 50; i >= 0; --i) {
			hamster.write(Hamster.LEFT_WHEEL, i);
			hamster.write(Hamster.RIGHT_WHEEL, i);
			wait(20);
		}

		// don't forget to dispose
		hamster.dispose();
	}

	private static void wait(int millisec) {
		try {
			Thread.sleep(millisec);
		} catch (InterruptedException e) {
		}
	}
}