package examples.roboid.hamster;

import roboid.hamster.Hamster;

public class Example05_StaggeringWalk {
	public static void main(String[] args) {
		final Hamster hamster = new Hamster();

		int count = 10;
		int accX;
		while(count > 0) {
			hamster.write(Hamster.LEFT_WHEEL, -100);
			hamster.write(Hamster.RIGHT_WHEEL, -100);
			accX = hamster.read(Hamster.ACCELERATION);
			if(accX > 2000 || accX < -2000) {
				hamster.write(Hamster.LEFT_WHEEL, 100);
				hamster.write(Hamster.RIGHT_WHEEL, 100);
				wait(250);
				
				hamster.write(Hamster.LEFT_WHEEL, -50);
				hamster.write(Hamster.RIGHT_WHEEL, 50);
				wait(500);

				--count;
			}
		}

		hamster.dispose();
	}

	private static void wait(int millisec) {
		try {
			Thread.sleep(millisec);
		} catch (InterruptedException e) {
		}
	}
}