package examples.roboid.hamster;

import roboid.hamster.Hamster;

public class Example06_Siren {
	public static void main(String[] args) {
		final Hamster hamster = new Hamster();

		int count = 0, buzzer;
		for(int i = 0; i < 200; ++i) {
			buzzer = count + 500;
			count += 10;
			if(count > 200) count = 0;
			hamster.write(Hamster.BUZZER, buzzer);
			wait(20);
		}

		hamster.dispose();
	}

	private static void wait(int millisec) {
		try {
			Thread.sleep(millisec);
		} catch (InterruptedException e) {
		}
	}
}