package examples.roboid.hamster;

import org.roboid.robot.Controller;
import org.roboid.robot.Robot;

import roboid.hamster.Hamster;

public class Example07_ThereminSound implements Controller {
	private double note;

	public void start() {
		Hamster hamster = new Hamster();
		hamster.setController(this);

		// 10 seconds
		try {
			Thread.sleep(10000);
		} catch (InterruptedException e) {
		}

		hamster.dispose();
	}

	@Override
	public void execute(Robot robot) {
		int proximity = robot.read(Hamster.LEFT_PROXIMITY);
		if(proximity < 10) {
			proximity = 0;
		}
		note = (note * 9 + proximity) / 10;
		robot.write(Hamster.NOTE, (int)note);
	}

	public static void main(String[] args) {
		new Example07_ThereminSound().start();
	}
}