package examples.roboid.hamster;

import org.roboid.robot.Controller;
import org.roboid.robot.Robot;

import roboid.hamster.Hamster;

public class Example08_SimpleHandFollower implements Controller {
	public void start() {
		Hamster hamster = new Hamster();
		hamster.setController(this);

		// 10 seconds
		try {
			Thread.sleep(10000);
		} catch (InterruptedException e) {
		}

		hamster.dispose();
	}

	@Override
	public void execute(Robot robot) {
		int leftProximity = robot.read(Hamster.LEFT_PROXIMITY);
		int rightProximity = robot.read(Hamster.RIGHT_PROXIMITY);

		// left wheel
		if(leftProximity > 15) {
			robot.write(Hamster.LEFT_WHEEL, (40 - leftProximity) * 4);
		} else {
			robot.write(Hamster.LEFT_WHEEL, 0);
		}

		// right wheel
		if(rightProximity > 15) {
			robot.write(Hamster.RIGHT_WHEEL, (40 - rightProximity) * 4);
		} else {
			robot.write(Hamster.RIGHT_WHEEL, 0);
		}
	}

	public static void main(String[] args) {
		new Example08_SimpleHandFollower().start();
	}
}