package examples.roboid.hamster;

import org.roboid.robot.Controller;
import org.roboid.robot.Robot;

import roboid.hamster.Hamster;

public class Example09_DualThereminSound {
	private static final int NUM_ROBOTS = 2;
	private double note1, note2;

	public void start() {
		Hamster.waitUntilReady(NUM_ROBOTS);
		Hamster hamster1 = new Hamster();
		Hamster hamster2 = new Hamster();

		hamster1.setController(new Controller() {
			@Override
			public void execute(Robot robot) {
				int proximity = robot.read(Hamster.LEFT_PROXIMITY);
				if(proximity < 10) {
					proximity = 0;
				}
				note1 = (note1 * 9 + proximity) / 10;
				robot.write(Hamster.NOTE, (int)note1);
			}
		});
		hamster2.setController(new Controller() {
			@Override
			public void execute(Robot robot) {
				int proximity = robot.read(Hamster.LEFT_PROXIMITY);
				if(proximity < 10) {
					proximity = 0;
				}
				note2 = (note2 * 9 + proximity) / 10;
				robot.write(Hamster.NOTE, (int)note2);
			}
		});

		// 10 seconds
		try {
			Thread.sleep(10000);
		} catch (InterruptedException e) {
		}

		hamster1.dispose();
		hamster2.dispose();
	}

	public static void main(String[] args) {
		new Example09_DualThereminSound().start();
	}
}