package examples.roboid.hamster;

import roboid.hamster.Hamster;

public class Example10_MutipleBasicMovement {
	public static void main(String[] args) {
		final int NUM_ROBOTS = 4;
		final Hamster[] hamsters = new Hamster[NUM_ROBOTS];

		Hamster.waitUntilReady(NUM_ROBOTS);
		for(int i = 0; i < NUM_ROBOTS; ++i) {
			hamsters[i] = new Hamster();
		}

		for(int i = 0; i < 10; ++i) {
			for(Hamster hamster : hamsters) {
				hamster.write(Hamster.LEFT_WHEEL, 50);
				hamster.write(Hamster.RIGHT_WHEEL, 50);
			}
			wait(500);

			for(Hamster hamster : hamsters) {
				hamster.write(Hamster.LEFT_WHEEL, -50);
				hamster.write(Hamster.RIGHT_WHEEL, -50);
			}
			wait(500);

			for(Hamster hamster : hamsters) {
				hamster.write(Hamster.LEFT_WHEEL, -50);
				hamster.write(Hamster.RIGHT_WHEEL, 50);
			}
			wait(500);
		}

		for(Hamster hamster : hamsters) {
			hamster.dispose();
		}
	}

	private static void wait(int millisec) {
		try {
			Thread.sleep(millisec);
		} catch (InterruptedException e) {
		}
	}
}