package examples.roboid.hamster;

import org.roboid.robot.Controller;
import org.roboid.robot.Robot;

import roboid.hamster.Hamster;

public class Example11_MultipleHandFollower implements Controller {
	private static final int NUM_ROBOTS = 4;

	public void start() {
		final Hamster[] hamsters = new Hamster[NUM_ROBOTS];

		Hamster.waitUntilReady(NUM_ROBOTS);
		for(int i = 0; i < NUM_ROBOTS; ++i) {
			hamsters[i] = new Hamster();
			hamsters[i].setController(this);
		}

		// 10 seconds
		try {
			Thread.sleep(10000);
		} catch (InterruptedException e) {
		}

		for(Hamster hamster : hamsters) {
			hamster.dispose();
		}
	}

	@Override
	public void execute(Robot robot) {
		// left wheel
		int proximity = robot.read(Hamster.LEFT_PROXIMITY);
		if(proximity > 15) {
			robot.write(Hamster.LEFT_WHEEL, (40 - proximity) * 4);
		} else {
			robot.write(Hamster.LEFT_WHEEL, 0);
		}

		// right wheel
		proximity = robot.read(Hamster.RIGHT_PROXIMITY);
		if(proximity > 15) {
			robot.write(Hamster.RIGHT_WHEEL, (40 - proximity) * 4);
		} else {
			robot.write(Hamster.RIGHT_WHEEL, 0);
		}
	}

	public static void main(String[] args) {
		new Example11_MultipleHandFollower().start();
	}
}