# author: Kwang-Hyun Park (akaii@kw.ac.kr)

# simple hand follower
from roboid.hamster import *

def execute(robot):
	leftProximity = robot.read(Hamster.LEFT_PROXIMITY)
	rightProximity = robot.read(Hamster.RIGHT_PROXIMITY)

	# left wheel
	if leftProximity > 15:
		robot.write(Hamster.LEFT_WHEEL, (40 - leftProximity) * 4)
	else:
		robot.write(Hamster.LEFT_WHEEL, 0)

	# right wheel
	if rightProximity > 15:
		robot.write(Hamster.RIGHT_WHEEL, (40 - rightProximity) * 4)
	else:
		robot.write(Hamster.RIGHT_WHEEL, 0)

robot = Hamster()
robot.setExecutable(execute)

# 10 seconds
wait(10000)

disposeAll()