# author: Kwang-Hyun Park (akaii@kw.ac.kr)

# dual theremin sound
from roboid.hamster import *

note1 = 0
note2 = 0
def execute1(robot):
	global note1
	proximity = robot.read(Hamster.LEFT_PROXIMITY)
	if proximity < 10: proximity = 0
	note1 = (note1 * 9 + proximity) / 10
	robot.write(Hamster.NOTE, note1)

def execute2(robot):
	global note2
	proximity = robot.read(Hamster.LEFT_PROXIMITY)
	if proximity < 10: proximity = 0
	note2 = (note2 * 9 + proximity) / 10
	robot.write(Hamster.NOTE, note2)

robots = (Hamster(), Hamster())
robots[0].setExecutable(execute1)
robots[1].setExecutable(execute2)

# 10 seconds
wait(10000)

disposeAll()