# Keyboard Piano
# author: Kwang-Hyun Park (akaii@kw.ac.kr)

# Ctrl + C to terminate

from roboid import *

hamster = Hamster()
notes = {
    " ": Hamster.NOTE_OFF,
    "a": Hamster.NOTE_C_4,
    "w": Hamster.NOTE_C_SHARP_4,
    "s": Hamster.NOTE_D_4,
    "e": Hamster.NOTE_E_FLAT_4,
    "d": Hamster.NOTE_E_4,
    "f": Hamster.NOTE_F_4,
    "t": Hamster.NOTE_F_SHARP_4,
    "g": Hamster.NOTE_G_4,
    "y": Hamster.NOTE_G_SHARP_4,
    "h": Hamster.NOTE_A_4,
    "u": Hamster.NOTE_B_FLAT_4,
    "j": Hamster.NOTE_B_4,
    "k": Hamster.NOTE_C_5,
    "o": Hamster.NOTE_C_SHARP_5,
    "l": Hamster.NOTE_D_5,
    "p": Hamster.NOTE_E_FLAT_5,
    ";": Hamster.NOTE_E_5,
    "'": Hamster.NOTE_F_5
}

while True:
    key = Keyboard.read()
    if key and key in notes:
        hamster.note(0, 0.05) # break for the same notes
        hamster.note(notes[key])
    wait(10) # 10 msec