# Dual Theremin Sound
# author: Kwang-Hyun Park (akaii@kw.ac.kr)

# Ctrl + C to terminate

from roboid import *

hamster1 = HamsterS()
hamster2 = HamsterS()

# wait until two robots are ready
wait_until_ready()

pitch1 = 0
pitch2 = 0
while True:
    proximity = hamster1.left_proximity()
    if proximity < 10:
        proximity = 0
    pitch1 = (pitch1 * 9 + proximity) / 10.0
    hamster1.note(pitch1)

    proximity = hamster2.left_proximity()
    if proximity < 10:
        proximity = 0
    pitch2 = (pitch2 * 9 + proximity) / 10.0
    hamster2.note(pitch2)

    wait(20) # 20 msec