# Advanced Theremin Sound
# author: Kwang-Hyun Park (akaii@kw.ac.kr)

from roboid import *

turtle = Turtle()
pitch = 0

def execute():
    global pitch
    
    floor = turtle.floor()
    if floor < 10:
        floor = 0
    pitch = (pitch * 9 + floor) / 10.0
    turtle.note(pitch)

# set a periodic (20 msec) callback
set_executable(execute)

wait(10000) # 10 seconds
turtle.note(0) # clear note