# Part of the ROBOID project - http://hamster.school
# Copyright (C) 2016 Kwang-Hyun Park (akaii@kw.ac.kr)
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General
# Public License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330,
# Boston, MA  02111-1307  USA

import sys
import serial.tools.list_ports


class Scanner(object):
    @staticmethod
    def scan():
        sys.stdout.write('Serial ports:\n')
        ports = serial.tools.list_ports.comports()
        count = 0
        for port in ports:
            count += 1
            sys.stdout.write('{}\n'.format(port[0]))
        if count <= 0:
            sys.stdout.write('No available serial port\n')