# Part of the ROBOID project - http://hamster.school
# Copyright (C) 2016 Kwang-Hyun Park (akaii@kw.ac.kr)
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General
# Public License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330,
# Boston, MA  02111-1307  USA

import signal

from roboid.scanner import Scanner
from roboid.keyboard import Keyboard
from roboid.runner import Runner
from roboid.model import DeviceType
from roboid.model import DataType
from roboid.hamster import Hamster

__version__ = '1.3.1'

__all__ = ['DeviceType', 'DataType', 'Hamster', 'Keyboard', 'scan', 'set_executable', 'wait', 'wait_until_ready', 'wait_until']

def scan():
    Scanner.scan()

def set_executable(execute):
    Runner.set_executable(execute)

def wait(milliseconds):
    Runner.wait(milliseconds)

def wait_until_ready():
    Runner.wait_until_ready()

def wait_until(evaluate):
    Runner.wait_until(evaluate)

def _handle_signal(signal, frame):
    Runner.shutdown()
    raise SystemExit

signal.signal(signal.SIGINT, _handle_signal)