# Advanced Theremin Sound
# author: Kwang-Hyun Park (akaii@kw.ac.kr)

from roboid import *

hamster = Hamster()
pitch = 0

def execute():
    global pitch
    
    proximity = hamster.left_proximity()
    if proximity < 10:
        proximity = 0
    pitch = (pitch * 9 + proximity) / 10.0
    hamster.note(pitch)

# set a periodic (20 msec) callback
set_executable(execute)

wait(10000) # 10 seconds
hamster.note(0) # clear note