# Advanced Dual Theremin Sound
# author: Kwang-Hyun Park (akaii@kw.ac.kr)

from roboid import *

hamster1 = Hamster()
hamster2 = Hamster()
pitch1 = 0
pitch2 = 0

# wait until two robots are ready
wait_until_ready()

def execute():
    global pitch1
    global pitch2

    proximity = hamster1.left_proximity()
    if proximity < 10:
        proximity = 0
    pitch1 = (pitch1 * 9 + proximity) / 10.0
    hamster1.note(pitch1)

    proximity = hamster2.left_proximity()
    if proximity < 10:
        proximity = 0
    pitch2 = (pitch2 * 9 + proximity) / 10.0
    hamster2.note(pitch2)

# set a periodic (20 msec) callback
set_executable(execute)

wait(10000) # 10 seconds

# clear notes
hamster1.note(0)
hamster2.note(0)