# Parallel
# author: Kwang-Hyun Park (akaii@kw.ac.kr)

from roboid import *

hamster = Hamster()

# melody
def play_melody():
    for i in range(2):
        hamster.note(Hamster.NOTE_C_4, 0.5)
        hamster.note(Hamster.NOTE_E_4, 0.5)
        hamster.note(Hamster.NOTE_G_4, 0.5)

    for i in range(3):
        hamster.note(Hamster.NOTE_A_4, 0.5)

    hamster.note(Hamster.NOTE_G_4, 1)
    hamster.note(0, 0.5)

# blink
def play_blink():
    for i in range(5):
        hamster.leds(Hamster.LED_RED, Hamster.LED_RED)
        wait(500)
        hamster.leds(0, 0)
        wait(500)

# move
def play_move():
    hamster.move_forward()
    hamster.move_backward()
    hamster.turn_left()
    hamster.turn_right()

parallel(play_melody, play_blink, play_move)