# Dual Theremin Sound
# author: Kwang-Hyun Park (akaii@kw.ac.kr)

# Ctrl + C to terminate

from roboid import *

turtle1 = Turtle()
turtle2 = Turtle()

# wait until two robots are ready
wait_until_ready()

pitch1 = 0
pitch2 = 0
while True:
    floor = turtle1.floor()
    if floor < 10:
        floor = 0
    pitch1 = (pitch1 * 9 + floor) / 10.0
    turtle1.note(pitch1)

    floor = turtle2.floor()
    if floor < 10:
        floor = 0
    pitch2 = (pitch2 * 9 + floor) / 10.0
    turtle2.note(pitch2)

    wait(20) # 20 msec