# Advanced Dual Theremin Sound
# author: Kwang-Hyun Park (akaii@kw.ac.kr)

from roboid import *

turtle1 = Turtle()
turtle2 = Turtle()
pitch1 = 0
pitch2 = 0

# wait until two robots are ready
wait_until_ready()

def execute():
    global pitch1
    global pitch2

    floor = turtle1.floor()
    if floor < 10:
        floor = 0
    pitch1 = (pitch1 * 9 + floor) / 10.0
    turtle1.note(pitch1)

    floor = turtle2.floor()
    if floor < 10:
        floor = 0
    pitch2 = (pitch2 * 9 + floor) / 10.0
    turtle2.note(pitch2)

# set a periodic (20 msec) callback
set_executable(execute)

wait(10000) # 10 seconds

# clear notes
turtle1.note(0)
turtle2.note(0)