# Keyboard Piano
# author: Kwang-Hyun Park (akaii@kw.ac.kr)

# Ctrl + C to terminate

from roboid import *

turtle = Turtle()
notes = {
    " ": Turtle.NOTE_OFF,
    "a": Turtle.NOTE_C_4,
    "w": Turtle.NOTE_C_SHARP_4,
    "s": Turtle.NOTE_D_4,
    "e": Turtle.NOTE_E_FLAT_4,
    "d": Turtle.NOTE_E_4,
    "f": Turtle.NOTE_F_4,
    "t": Turtle.NOTE_F_SHARP_4,
    "g": Turtle.NOTE_G_4,
    "y": Turtle.NOTE_G_SHARP_4,
    "h": Turtle.NOTE_A_4,
    "u": Turtle.NOTE_B_FLAT_4,
    "j": Turtle.NOTE_B_4,
    "k": Turtle.NOTE_C_5,
    "o": Turtle.NOTE_C_SHARP_5,
    "l": Turtle.NOTE_D_5,
    "p": Turtle.NOTE_E_FLAT_5,
    ";": Turtle.NOTE_E_5,
    "'": Turtle.NOTE_F_5
}

while True:
    key = Keyboard.read()
    if key and key in notes:
        turtle.note(0, 0.05) # break for the same notes
        turtle.note(notes[key])
    wait(10) # 10 msec