# Advanced Multiple Color Pattern Detector
# author: Kwang-Hyun Park (akaii@kw.ac.kr)

from roboid import *

turtle1 = Turtle()
turtle2 = Turtle()

# user-defined function
def check_backward(robot):
    return robot.color_pattern() == (Turtle.COLOR_MAGENTA, Turtle.COLOR_RED)

# wait until the color pattern is (magenta, red)
wait_until(check_backward, turtle1)

turtle1.sound(Turtle.SOUND_BEEP) # beep
turtle1.move_backward() # move backward

# wait until the color pattern is (magenta, red)
wait_until(check_backward, turtle2)

turtle2.sound(Turtle.SOUND_BEEP) # beep
turtle2.move_backward() # move backward