# When-Do Color Pattern Detector
# author: Kwang-Hyun Park (akaii@kw.ac.kr)

# Ctrl + C to terminate

from roboid import *

turtle = Turtle()

# when the color pattern is (magenta, red)
def check_backward():
    return turtle.color_pattern() == (Turtle.COLOR_MAGENTA, Turtle.COLOR_RED)

# when the color pattern is (magenta, blue)
def check_forward():
    return turtle.color_pattern() == (Turtle.COLOR_MAGENTA, Turtle.COLOR_BLUE)

# move backward 6 cm
def move_backward():
    turtle.sound(Turtle.SOUND_BEEP)
    turtle.move_backward()

# move forward 6 cm
def move_forward():
    turtle.sound(Turtle.SOUND_BEEP)
    turtle.move_forward()

when_do(check_backward, move_backward)
when_do(check_forward, move_forward)

wait(-1) # wait forever