# Multiple When-Do Color Pattern Detector
# author: Kwang-Hyun Park (akaii@kw.ac.kr)

# Ctrl + C to terminate

from roboid import *

turtles = (Turtle(), Turtle(), Turtle(), Turtle())

# when the color pattern is (magenta, red)
def check_backward(robot):
    return robot.color_pattern() == (Turtle.COLOR_MAGENTA, Turtle.COLOR_RED)

# move backward 6 cm
def move_backward(robot):
    robot.sound(Turtle.SOUND_BEEP)
    robot.move_backward()

for turtle in turtles:
    when_do(check_backward, move_backward, turtle)

wait(-1) # wait forever